PROGRAM DisplayInterface
VAR_EXTERNAL
DisplayAddress : usint;
DisplayTimeSchedule1 : int;
DisplayTimeSchedule2 : int;
DisplayTimeSchedule3 : int;
DisplayTimeSchedule4 : int;
DisplayTimeSchedule5 : int;
DisplayTemperature : real;
DisplayTamper : int;
END_VAR
VAR_GLOBAL
END_VAR
VAR
Result : int;
DisplayModbusMaster : ModbusRegistersFB;
SaveRegistersTimer : int := 5001;
NewValue : real;
FirstRun : int := 1;
dwTemp : dword;
diTemp : dint;
END_VAR

(* Read some measurements from the display *)
DisplayModbusMaster(send:=0, SlaveAddress:=DisplayAddress, StartRegister:=3000, RegisterCount:=63, RegisterType:=3, TimeOut:=200, PollInterval:=2000);
DisplayTemperature := INT_TO_REAL(WORD_TO_INT(DisplayModbusMaster.Reg0))/10.0;
DisplayTamper := BOOL_TO_INT(DisplayModbusMaster.Reg6 = 1023);
DisplayTimeSchedule1 := WORD_TO_INT(DisplayModbusMaster.Reg7);
DisplayTimeSchedule2 := WORD_TO_INT(DisplayModbusMaster.Reg8);
DisplayTimeSchedule3 := WORD_TO_INT(DisplayModbusMaster.Reg9);
DisplayTimeSchedule4 := WORD_TO_INT(DisplayModbusMaster.Reg10);
DisplayTimeSchedule5 := WORD_TO_INT(DisplayModbusMaster.Reg11);
if (DisplayTamper = 1) then
    DisplayModbusMaster.Reg62 := 0;
    DisplayModbusMaster(send:=1);
end_if;

(* Save registers if any of the setpoints is changed *)
(* 50 loop delay is to let user do all the settings before saving *)
if (SaveRegistersTimer < 50) then
    SaveRegistersTimer := SaveRegistersTimer + 1;
elsif (SaveRegistersTimer = 50) then
    SaveRegistersTimer := SaveRegistersTimer + 1;
    Result := SaveRegistersF(1);
end_if;

FirstRun:=0;
END_PROGRAM
